%     NIT     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO GET DEFAULT SYSTEM STRUCTURE
% ======================================================
%   USAGE :
%         1. out = newnit('New', 'PSO', 20, 'GBest')
%         2. out = newnit('New', 'PSO', 20, 'LBest')
%         3. out = newnit
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function out = newnit(nitName, nitType, nitPSize, nitModel)
if nargin == 0
    Name = 'New';
    Type = 'PSO';
    PSize = 20;
    Model = 'GBest';
elseif nargin == 1
    Name = nitName;
    Type = 'PSO';
    PSize = 20;
    Model = 'GBest';
elseif nargin == 2
    Name = nitName;
    Type = nitType;
    PSize = 20;
    Model = 'GBest';
elseif nargin == 3
    Name = nitName;
    Type = nitType;
    PSize = nitPSize;
    Model = 'GBest';
elseif nargin == 4
    Name = nitName;
    Type = nitType;
    PSize = nitPSize;
    Model = nitModel;
end

if strcmp(Type, 'PSO') & strcmp(Model, 'GBest')
    out.Name = Name;
    out.Type = Type;
    out.String.File = '';
    out.String.Sheet = '';
    out.String.Range = '';
    out.Checks.File = '';
    out.Checks.Sheet = '';
    out.Checks.Range = '';
    out.Swarm.Model = Model;
    out.Swarm.PSize = PSize;
    out.Swarm.NSize = [];
    out.Swarm.Topology = [];
    out.Parameter.C1 = 0.1;
    out.Parameter.C2 = 0.2;
    out.Parameter.C3 = [];
    out.Parameter.MaxVelocity = 0.5;
    out.Parameter.Chi = 1;
    out.Parameter.WeightOption = 'Fixed';
    out.Parameter.StartWeight = 1;
    out.Parameter.EndWeight = [];
    out.Objective.File = '';
    out.Objective.Sheet = '';
    out.Objective.Range = '';
    out.Objective.Function = '';
    out.Terminate.NoChange = 10;
    out.Terminate.Goal = 0;
    out.Terminate.MaxIterations = 1000;
    out.Plot.GBest = 1;
    out.Plot.Average = 1;
    out.Plot.LBest = 0;
else
    out.Name = Name;
    out.Type = Type;
    out.String.File = '';
    out.String.Sheet = '';
    out.String.Range = '';
    out.Checks.File = '';
    out.Checks.Sheet = '';
    out.Checks.Range = '';
    out.Swarm.Model = Model;
    out.Swarm.PSize = PSize;
    out.Swarm.NSize = 1;
    out.Swarm.Topology = 'Ring';
    out.Parameter.C1 = 0.1;
    out.Parameter.C2 = 0.2;
    out.Parameter.C3 = 0.3;
    out.Parameter.MaxVelocity = 0.5;
    out.Parameter.Chi = i;
    out.Parameter.WeightOption = 'Variable';
    out.Parameter.StartWeight = 1;
    out.Parameter.EndWeight = 0;
    out.Objective.File = '';
    out.Objective.Sheet = '';
    out.Objective.Range = '';
    out.Objective.Function = '';
    out.Terminate.NoChange = 10;
    out.Terminate.Goal = 0;
    out.Terminate.MaxIterations = 1000;
    out.Plot.GBest = 1;
    out.Plot.Average = 1;
    out.Plot.LBest = 1;
end

if nargin<1
    out.Name = Name;
    out.Type = Type;

    out.String.File = 'Encoding.xls';
    out.String.Sheet = 'Particle';
    out.String.Range = 'B2:D91';

    out.Checks.File = 'Encoding.xls';
    out.Checks.Sheet = 'Checks';
    out.Checks.Range = 'A2:B21';

    out.Swarm.Model = Model;
    out.Swarm.PSize = PSize;
    out.Swarm.NSize = 3;
    out.Swarm.Topology = 'Ring';

    out.Parameter.C1 = 0.1;
    out.Parameter.C2 = 0.2;
    out.Parameter.C3 = 0.3;
    out.Parameter.MaxVelocity = 0.5;
    out.Parameter.Chi = 1;
    out.Parameter.WeightOption = 'Fixed';
    out.Parameter.StartWeight = 1;
    out.Parameter.EndWeight = 0;

    out.Objective.File = 'Training.xls';
    out.Objective.Sheet = 'Data';
    out.Objective.Range = 'A2:E501';
    out.Objective.Function = 'myObject';

    out.Terminate.NoChange = 10;
    out.Terminate.Goal = 0;
    out.Terminate.MaxIterations = 1000;

    out.Plot.GBest = 1;
    out.Plot.Average = 1;
    out.Plot.LBest = 0;
end